﻿CREATE PROCEDURE App.NVCC_usp_Get_UsersByFacility
	@sta6a int

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Ala Eldin Mohamed
--Object/SP Name		: NVCC_usp_Get_UsersByFacility
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 12-13-2017

--
--Purpose               : Retrieve list of User name's based on sta3n
--=================================================================================
--Uses: CC_REFDOC.[App].[NVCC_UsersV2] & CC_REFDOC.[App].[NVCC_UserFacilities]

BEGIN
    -- SET NOCOUNT ON added to prevent extra result sets from
    -- interfering with SELECT statements.
    SET NOCOUNT ON;
	select ada.AccountName as GivenName, users.UserName 
	from CC_REFDOC.App.NVCC_UsersV2 as users inner join 
	CDWWork.NDim.ActiveDirectoryAccount AS ada on ada.FullSamAccountName = users.UserName INNER JOIN
	[CC_REFDOC].[App].[NVCC_UserFacilities] as stations on users.UserId = stations.UserID 
	and sta3n = @sta6a
END;

